﻿init:
    # Basic configuration.
    $ config.screen_width = 800
    $ config.screen_height = 600
    #$ config.window_title = 'Procházky za měsíčního svitu / Moonlight Walks'
	# workaround do verze 5.5.1, tahle verze nepodporuje utf-8 v názvu aplikace
    $ config.window_title = 'Prochazky za mesicniho svitu / Moonlight Walks'
    $ config.window_icon = 'icon32.png'

    $ config.debug_sound = True

    # Styles
    $ style.mm_root_window.background = Image('beach1a.png')
    $ style.gm_root_window.background = Image('beach3.png')
    $ style.file_picker_entry.background = Frame('saveslot.png', 16, 16)
    $ style.file_picker_entry.xpadding = 2
    $ style.file_picker_entry.ypadding = 2

    $ style.mm_menu_window.background = Frame('saveslot.png', 16, 16)
    $ style.mm_menu_window.xpadding = 20
    $ style.mm_menu_window.ypadding = 20
    $ style.mm_menu_window.xpos = 0.5
    $ style.mm_menu_window.xanchor = 'center'
    $ style.mm_menu_window.ypos = 0.5
    $ style.mm_menu_window.yanchor = 'top'

    $ style.gm_nav_window.background = Frame('saveslot.png', 16, 16)
    $ style.gm_nav_window.xpadding = 20
    $ style.gm_nav_window.ypadding = 20
    $ style.gm_nav_window.xpos = 0.5
    $ style.gm_nav_window.xanchor = 'center'

    $ style.yesno_label.color = (255, 255, 0, 255)
    $ style.prefs_label.color = (255, 255, 0, 255)

    $ style.say_dialogue.rest_indent = 9

    # Windows
    $ style.window.xmargin = 0
    $ style.window.ymargin = 0
    $ style.window.background = Frame('background.png', 16, 16)
    $ style.window.xpadding = 10
    $ style.window.ypadding = 5

    # Sliders
    $ style.bar.left_gutter = 10
    $ style.bar.right_gutter = 12
    $ style.bar.left_bar = Frame("slider_full.png", 10, 0)
    $ style.bar.right_bar = Frame("slider_empty.png", 12, 0)
    $ style.bar.thumb = Image("slider_idle.png")
    $ style.bar.hover_thumb = Image("slider_hover.png")
    $ style.bar.thumb_shadow = Image("slider_shadow.png")
    $ style.bar.thumb_offset = -10

    # Transitions.
    # $ fade = Fade(.5, 0, .5) # Fade to black and back.
    $ dissolve = Dissolve(0.5)
    $ slowdissolve = Dissolve(1.0)

    # Images.
    image black = Solid((0, 0, 0, 255))
    image white = Solid((255, 255, 255, 255))
    image yellow = Solid((255, 255, 200, 255))

    # Opening Sequence.
    image bigbeach1 = Image("bigbeach1.png")
    image presents = Image("presents.png")

    # Backgrounds.
    image beach1 = Image("beach1b.png")
    image beach1 mary = Image("beach1c.png")
    image beach1 title = Image("beach1a.png")
    image beach1 nomoon = Image("beach1d.png")

    image beach2 = Image("beach2.png")
    image beach3 = Image("beach3.png")

    image dawn1 = Image("dawn1.jpg")
    image dawn2 = Image("dawn2.jpg")

    image library = Image("library.png")

    # Ending 1.
    image transfer = Image("transfer.png")
    image moonpic = Image("moonpic.jpg")
    image nogirlpic = Image("nogirlpic.jpg")

    # Ending 3.
    image littlemary = Image("littlemary.jpg")

    # Ending 4.
    image hospital1 = Image("hospital1.jpg")
    image hospital3 = Image("hospital3.jpg")
    image heaven = Image("heaven.jpg")

    # Endings Common
    image good_ending = Image("ending.jpg")
    image bad_ending = Image("badending.jpg")

    # Mary.
    image mary dark confused smiling = Image("mary_dark_confused_smiling.png")
    image mary dark confused wistful = Image("mary_dark_confused_wistful.png")
    image mary dark crying = Image("mary_dark_crying.png")
    image mary dark laughing = Image("mary_dark_laughing.png")
    image mary dark sad = Image("mary_dark_sad.png")
    image mary dark smiling = Image("mary_dark_smiling.png")
    image mary dark vhappy = Image("mary_dark_vhappy.png")
    image mary dark wistful = Image("mary_dark_wistful.png")

    image mary dawn confused smiling = Image("mary_dawn_confused_smiling.png")
    image mary dawn confused wistful = Image("mary_dawn_confused_wistful.png")
    image mary dawn smiling = Image("mary_dawn_smiling.png")
    image mary dawn vhappy = Image("mary_dawn_vhappy.png")
    image mary dawn wistful = Image("mary_dawn_wistful.png")


    # Characters.
    $ narrator = Character("", who_suffix='', what_prefix='', what_suffix='', what_style='say_thought')

    $ p = Character("", who_suffix='', what_prefix='"', what_suffix='"')
    $ pm = Character("Já, mluvící jako duchovní", who_suffix=': ', what_prefix='"', what_suffix='"')

    $ g = Character("Dívka", who_suffix=': ', what_prefix='"', what_suffix='"', color=(255, 128, 128, 255))
    $ m = Character("Mary", who_suffix=': ', what_prefix='"', what_suffix='"', color=(255, 128, 128, 255))
    $ lm = Character(u"Vnučka", who_suffix=': ', what_prefix='"', what_suffix='"', color=(255, 255, 128, 255))

    # Menus
    $ library.main_menu.insert(2, (u"Galerie", "gallery", "True"))

    # Translations.
    $ library.translations = {
        u'Hlasitost hudby' : u'Hlasitost',
        }

    python hide:
        library.has_sound = False

        for i in range(0, 8):
            renpy.sound.set_mixer(i, 'music')

        library.preferences['prefs_center'].remove(library.all_preferences[u'Rychlost textu'])
        library.preferences['prefs_right'].append(library.all_preferences[u'Rychlost textu'])
        library.preferences['prefs_center'].remove(library.all_preferences[u'Auto-vpřed čas'])
        library.preferences['prefs_right'].append(library.all_preferences[u'Auto-vpřed čas'])

        library.enter_transition = dissolve
        library.exit_transition = dissolve

    python:
        if not persistent.set_fullscreen:
            persistent.set_fullscreen = True
            _preferences.fullscreen = True

    $ dont_set_music = False

label splashscreen:

    scene black
    with None

    scene bigbeach1 at Pan((0, 0), (0, 1200), 13.0)

    if renpy.with(slowdissolve):
         jump end_splash

    # 1.0 s

    if renpy.pause(1.0):
        jump end_splash

    # 2.0 s

    show presents at Position(yanchor='center', ypos=0.5)

    if renpy.with(slowdissolve):
        jump end_splash

    # 3.0 s

    if renpy.pause(5.0):
        jump end_splash

    # 8.0 s

    hide presents

    if renpy.with(slowdissolve):
        jump end_splash

    # 9.0 s
    $ renpy.music.play('waves.ogg', fadein=5.5)
    $ dont_set_music = True

    if renpy.pause(4.5):
        jump end_splash

    # 13.5 s

label end_splash:

    return

label main_menu:
    if not dont_set_music:
        $ renpy.music.play('waves.ogg', fadeout=1, fadein=1)

    $ dont_set_music = True

    $ renpy.transition(slowdissolve)
    jump _library_main_menu


label start:

    # Set the music on return to the main menu.
    $ dont_set_music = False

    # Did she tell us her family history?
    $ family_history = False

    # Did we decide to meet again?
    $ meet_again = False

    $ renpy.clear_game_runtime()
    $ renpy.music_start('waves.ogg')

    scene beach1 title
    with dissolve
    scene beach1
    with slowdissolve

    "Bylo léto před tím, než jsem nastoupil na univerzitu. Strávil
     jsem předchozí dva roky studiem, děláním testů a podáváním přihlášek."

    "Teď, poprvé po nějakém čase jsem měl trochu volna. Tak jsem se rozhodl
     využít příležitosti a prozkoumat Ameriku."

    "Ale vzhledem k tomu, že jsem byl bez peněz, moje plány byly rychle
     zredukované na strávení léta v domě  mé tety a strýce na malém
     ostrůvku známém jako North Sand Island."

    "North Sand Island byl bariérový ostrov v Atlantském oceáně. Byl
     příliš vzdálený na to, aby k němu vedl most, jen trajekt tam
     připlouval několikrát denně."

    "Protože to byl takový malý ostrov, nebylo mnoho věcí, které by se
     tam daly dělat. Ale osamělost byla hezká a já našel způsoby, jak si
     zkrátit čas."

    "Jedna z věcí které jsem dělal bylo focení s mým digitálním foťákem.
     V noci, když byl úplněk jsem se rozhodl zachytit východ měsíce."

    "A tak jsem vyrazil na pláž těsně před tím než se měsíc objevil, dal
     jsem foťák na stativ, nastavil odpovídající uzávěrku a clonové číslo."

    "Každých pár vteřin, jak se měsíc vynořoval nad obzor používal jsem
     dálkové ovládání dodávané s foťákem k zachycení dalšího snímku
     měsíce a jeho odrazu ve vodě."

    "Trvalo to jenom několik minut než se měsíc vynořil nad horizont, ale
     já jsem v tom ještě chvíli pokračoval."

    "Konečně jsem skončil. Začal jsem balit foťák a podstavec,
     abych se mohl vrátit do tetina a strýcova domu."

    scene beach1 mary with dissolve

    "Tehdy jsem ji poprvé uviděl. V dálce jsem viděl někoho, jak jde po pláži."

    "Řekl bych, že to nejspíš byla dívka nebo žena podle dlouhých bílých
     šatů které měla oblečené, ale z té dálky bylo těžké říct o ní něco jiného."

    "Rozhodl jsem se počkat, abych zjistil kdo to je. Za tu dobu co jsem
     pozoroval hvězdy jsem nikdy nepotkal někoho procházejícího se po
     pláži uprostřed noci."

    "V tak pozdní hodinu většina lidí byla buď doma nebo ve městě s
     ostatními lidmi. Bylo těžké potkat někoho samotného."

    "Někoho jiného jsem viděl na pláži v noci, jen když
     pozorovali hvězdy nebo prolétající družice."

    "Ale ti lidé stáli nehybně na místě a dívali se na oblohu, zatímco
     tato dívka se dívala dolů na zem před sebou, sledujíc kam jde."

    "V hlavě mi proběhla řada bláznivých scénářů. Možná že měla nějaký druh
     nemoci, který způsobil, že nemůže být na slunci. Možná že hledala
     zakopaný poklad."

    "Trvalo mi jen chvilku než jsem je pustil z hlavy. Jaká je šance,
     že by mohly skutečně nastat?"

    "Chvíli jsem čekal, jak pomalu pokračovala ve své cestě po pláži.
     Nemyslel jsem, že by taková pomalá chůze mohla sloužit jako
     cvičení, ale netušil jsem co jiného by tu mohla dělat."

    # Change Mary's size.

    "Nakonec byla dost blízko, takže jsem si ji mohl dobře prohlédnout
     za pomoci teleobjektivu mého fotoaparátu."

    "Byla to nejhezčí dívka, kterou jsem kdy viděl. Byla přibližně
     mého věku, nanejvýš rok nebo dva mladší nebo starší a dobře
     vypadající."

    "Její pokožka byla dokonalá i když trochu bledá, a její vlasy byly
     velmi světlé, stejně jako její šaty."

    "Dohromady kombinace bledé pokožky, světlých vlasů a bílých
     šatů způsobila, že vypadala jakoby zářila v měsíčním svitu."

    "Byla docela daleko a byl jsem si jistý, že mě neviděla. Věděl
     jsem co chci udělat."

menu menu_1:

    "Věděl sem, že si ji chci vyfotit.":
        jump take_her_picture

    "Věděl sem, že s ní musím mluvit.":
        jump talk_to_her


# 14 lines.
label take_her_picture:

    "Myslel jsem, že bych selhal jako fotograf, kdybych nechal
     odejít takové nádherné stvoření, bez toho aniž bych ji zachytil,
     takže jsem si připravil kameru k jejímu vyfocení."

    "Nedal jsem jí najevo, že jsem tady. Je nejlepší fotit nic netušící lidi,
     protože když vědí, že jsou focení tak mají sklon chovat se nepřirozeně."

    "Nastavil jsem foťák na automatiku, našel ji v hledáčku a stiskl spoušť.
     Kamera jemně zapípala, jak zachytila obraz."

    "To jsem tucetkrát zopakoval. Zjistil sem, že pomáhá nafotit mnoho
     obrázků, v naději, že jeden nebo dva se povedou perfektně."

    "Když jsem skončil s focením spustil jsem foťák a zamával jí."

    "Po několika vteřinách si mě konečně všimla a zamávala mi nazpět."

    "Ale byla ještě docela daleko, takže kdybych na ni zkusil mluvit
     můj hlas by zanikl v hluku tříštících se vln."

    "Dal jsem foťák zpátky do pouzdra, vzal jsem stativ a vydal se
     zpátky do domu tety a strýce."

    $ renpy.music_stop()
    $ renpy.play('click.wav')

    scene transfer

    "Když jsem se vrátil připojil jsem kameru k počítači a začal
     jsem stahovat fotky které jsem té noci vyfotil."

    scene moonpic

    "Série fotografií měsíce se podařila, ale to nebylo to co
     mě opravdu zajímalo."

    "Rychle sem je prošel, dívajíc se po obrázcích vyfocené dívky."


    $ renpy.play('click.wav')
    scene transfer

    "Ale když sem se k nim konečně dostal bylo na nich něco podivného."

    scene nogirlpic

    "Ona tam nebyla."

    "Byl jsem si skoro jistý, že jsem foťák namířil správně, ale všechno
     co jsem viděl byla písčitá pláž v místech kde stála."

    "Byla tam řada obrázků jako tento. Na každém z nich bylo pozadí
     které sem zaměřil, ale ona nebyla nikde k nalezení."

    "Musel jsem strávit snad hodinu pomalu procházejíc obrázky dívky,
     které jsem nafotil, nadarmo doufajíc že se objeví alespoň na
     jednom z nich."

    "Ale nikdy tam nebyla."

    "Kombinace její tajemné krásy a podivnost těch obrázků vtiskla
     její obraz do mé mysli."

    "Dokonce dnes, o roky později, můžu zavřít oči, vrátit se ve vzpomínkách
     nazpět a vidět ji, stejně jako jsem ji viděl toho dne skrz objektiv."

    $ renpy.music_start('waves.ogg')
    scene beach1 nomoon with dissolve

    "Šel jsem pozorovat hvězdy na pláž ještě několikrát během toho léta,
     doufajíc, že ji znovu uvidím."

    "Ale to se nikdy nestalo."


    # .:. Ending 1 "No Dialogue"
    $ ending = 1, "Beze slov"
    $ persistent.unlock_1 = True
    jump ending


label talk_to_her:

    "Jak se dívka přibližovala, rozhodl jsem se, že to nejlepší, co
     můžu udělat je dát pryč kameru a počkat až přijde blíž."

    "Nechtěl jsem ji vylekat tím že bych k ní běžel, nebo na ni
     křičet přes hluk vln oceánu."

    with dissolve
    scene beach1
    show mary dark wistful
    with dissolve

    "Po tom co jsem trpělivě čekal alespoň dvacet minut byla konečně
     dost blízko, abych na ni mohl mluvit přiměřeným hlasem."

    p "Ahoj."

    "Možná, že to nebyla nejvýmluvnější ze všech vět, ale bylo to všechno,
     co jsem byl v tu chvíli schopný vymyslet a splnilo to svůj účel."

    "Zastavila a podívala se na mě jako kdyby čekala, že řeknu
     ještě něco jiného."

    p "Je to hezká noc. Je teplo, ale ne horko."

    "Na tohle přikývla, ale nic neřekla. Nakonec jsem se rozhodl
     přerušit ticho a položit jí otázku, která mi ležela v hlavě."

    p "Takže, co tu děláš?"

    g "Procházím se."

    p "Prostě... procházíš? Uprostřed noci?"

    g "Ano."

    p "Máš někam namířeno?"

    g "Jdu kolem ostrova podél pláže."

    "Ostrov nebyl nijak veliký. Mohl bych ho obejít za pár hodin,
     možná o něco víc pokud bych po cestě odpočíval. Neměl bych
     problém držet s ní krok."


    p "Vadilo by, ti kdybych šel s tebou?"

    g "Pokud to je co chceš."

    "Rozhodl jsem se vzít foťák s sebou, ale stativ a brašnu jsem
     schoval v dunách."

    "To trvalo jen několik vteřin a my jsme rychle vyrazili po pláži."


    scene beach2 with dissolve

    "Chvíli jsme kráčeli v tichu, až do místa kdy už jsem neviděl
     odkud jsme vyrazili."

    "Stejně jsem se podíval zpět a viděl jsem jenom naše stopy v
     písku pláže."

    "Procházení se bylo skvělé, ale já jsem potřeboval promluvit si
     s touto dívkou. Rozhodl jsem se zjistit proč byla venku v noci."

    p "Takže..."

    show mary dark wistful with dissolve

    "Zastavila a podívala se na mě."

    p "Je tu nějaký důvod proč se procházíš po pláži v noci?"

    g "Je to něco co dělám."

    p "Aha. Děláš to často?"

    g "Připadá mi, že to dělám každý den."

    p "Chodíš vždycky sama, nebo někdo chodí s tebou?"

    g "Obvykle chodím sama. Ale čas od času někoho potkám a oni
       se někdy rozhodnou jít se mnou."

    g "Stalo se to jenom několikrát, ačkoliv nemyslím že někdo měl
       tolik otázek jako ty."

    "Nevěděl jsem jak si to mám přebrat a tak jsme na chvíli stáli potichu."

    show mary dark smiling

    "Konečně se trochu zasmála, usmála se a přebrala iniciativu."

    g "Cos tady venku dělal ty?"

    "Nemyslel jsem si, že bych ji mohl zajímat, a tak mi chvíli trvalo než jsem odpověděl na její otázku."

    "Když viděla moje váhání, vysvětlila."

    g "Myslím, že se oba shodneme, že je vzácné potkat někoho v noci na
       pláži jako je tato. Takže co jsi tu dělal?"

    "Trvalo mi další chvilku, abych si vzpomenul co jsem dělal a pak
    jsem jí konečně odpověděl."

    p "Zajímá mě astronomie... no, pozorování hvězd ve skutečnosti.
       Byl jsem venku, abych nafotil digitální fotky východu měsíce."

    show mary dark confused wistful

    "Tázavě se na mě podívala, jako kdyby nevěděla o čem mluvím. Připadlo
    mi to trochu zvláštní, protože sem si myslel, že každý ví co je to
    digitální fotoaparát."

    menu menu_01171024:
        "Rozhodl jsem se jí ukázat můj foťák.":

            "Rozhodl jsem se, že nejjednodušší způsob jak jí to vysvětlit
             bude ukázat jí některé z obrázků, které jsem vyfotil a tak jsem
             vytáhl foťák z pouzdra a zapnul ho."

            "Přepnul jsem ho na zobrazování obrázků a vyvolal jednu z
             posledních fotek, která ukazovala celý měsíční disk."

            "Podržel jsem dívce foťák tak, aby viděla obrázek na
             jeho obrazovce."

            "Dlouze se na něj podívala, potom se otočila, aby se podívala
             na měsíc a potom znovu dlouze na obrazovku."

            g "Měsíc... je tak malý."

            "Nevěděl sem k čemu přesně se snaží dobrat."

            p "Tady jsou obrázky malé, ale na obrazovce počítače budou
               vypadat mnohem větší."

            "Snažil sem se jí to vysvětlit, ale vypadalo to, že jsem ji mátl
             ještě víc a tak sem se rozhodl změnit téma."

        "Rozhodl jsem se jí ukázat měsíc.":

            p "Když jsem byl malý astronomie mě hodně zajímala. Mohl
               jsem se podívat na měsíc a pojmenovat všechny moře."

            g "Opravdu?"

            p "No teď už to nemůžu udělat. Ale pořád si pamatuji, kde jedno
               z moří leží."

            hide mary

            "Ukázal jsem na měsíc, a ona se na otočila aby se na něj
             podívala."

            p "Všimni si pravé strany měsíce. Když se podíváš, můžeš vidět
               něco co vypadá jako hoch s hlavou, tělem a dvěma nohama."

            p "Vidíš ho?"

            g "Vidím!"

            "Vypadala tím rozrušená, jako kdyby se na měsíc nikdy
             předtím nepodívala tímhle způsobem. Možná, že to
             tak bylo."

            "Lidé se dívají na měsíc různými způsoby. Někteří tam vidí
             muže, další hocha a dívku a jiní králíka."

            p "Když se podíváš na jeho tělo tak to je moře klidu,
               kde se procházeli Neil Armstrong a Buzz Aldrin."

            show mary dark confused smiling with dissolve

            g "Buzz? Jako když bzučí?"

            p "No jeho skutečné jméno bylo Edwin. Ale každý mu říkal
               Buzz. Netuším proč."

            "Pár vteřin nic neříkala jak to vstřebávala."

            g "Takže jsou lidé, kteří chodí po měsíci?"

            p "Už ne. Poslední lidi tam byli v sedmdesátých letech a
               od té doby tam nikdo nebyl."

            g "Takže my jsme je tam poslali?"

            p "Ano. Každý člověk na měsíci byl Američan."

            show mary dark smiling

            "Na toto se usmála, jako kdyby to právě zjistila a
             měla z toho velikou radost."

            "Myslel jsem si nicméně, že je to zvláštní, že neslyšela o
             přistáních na měsíci. Myslel jsem, že všichni se to dozvěděli
             už když byli mladí."

            "Stejně mi to ale dalo pocit uspokojení, že jsem byl ten,
             kdo jí o nich řekl."

            "Rozhodl jsem se změnit téma na něco o čem jsem si byl
             jistý, že o tom může mluvit."

    p "Tys tady vyrostla?"

    show mary dark smiling

    g "Ano vyrostla jsem tu."

    g "Když jsem vyrůstala nebyly tu na ostrově všechny ty domy a budovy."

    g "Jediné co na ostrově bylo byly farmy a ty byly obrovské."

    g "Žily tu jenom čtyři rodiny a ty vlastnily všechnu půdu na ostrově."

    g "Moje rodina byla jedna z těch čtyř. Vlastnili jsme jižní konec ostrova, kde jsme se setkali."

    g "Nevyčistili jsme všechnu naši zem, ale měli jsme dost velikou farmu\
       takže jsme mohli vypěstovat tolik jídla, kolik jsme potřebovali\
       a ještě jsme mohli prodávat na trhu."

    "Netušil jsem, že populace ostrova byla donedávna tak malá. Věděl\
     sem že turismus může zvýšit populaci... ale tak rychle?"

    p "Takže chodilas do školy na pevnině?"

    g "Jednou za čas. Když jsme přepluli trajektem prodávat naše produkty\
       strávili jsme několik dní ve škole zkouškami."

    g "Ale většinu času jsme studovali doma."

    g "Mamka nás učila čtení a psaní a taťka nás učil matematiku a tak."

    show mary dark wistful

    g "Alespoň před tím než umřeli..."

    "S tímhle její úsměv zmizel. Bylo jasné, že pro ni je těžké o tom mluvit."

menu menu_2:

    "Zeptal jsem se na její rodiče.":
        jump asked_about_parents

    "Upustil sem od tématu.":
        jump dropped_it

label asked_about_parents:

    $ family_history = True

    p "Co mi můžeš říct o svých rodičích?"

    g "Taťka a mamka přišli přes oceán jako osadníci, když byli ještě děti."

    g "Taťka bojoval ve válce. Když skončila oženil se s mamkou a použili\
       jeho penzion, aby se sem přesunuli z pevniny a postavili nám dům."

    g "Spolu obdělávali zemi a nakonec měli děti."

    g "Měla jsem starší a mladší sestru. Byla jsem prostřední."

    show mary dark sad

    "Na chvíli přestala, aby posbírala myšlenky, před pokračováním.\
     Tahle část pro ni byla namáhavá."

    g "Bylo mi deset, když epidemie zasáhla ostrov."

    g "Onemocněli jsme jí a stejně tak ostatní rodiny."

    g "Moje rodina byla příliš nemocná na to, aby se přesunula, ale\
       naši sousedi, Millerovi poslali některé z jejich chlapců pro\
       pomoc na pevninu."

    "Vzpomněl sem si, přemýšlejíc, že Millerovi bylo příjmení tety a strýce,\
     a uvažoval jsem jestli by mohli být se mnou příbuzní."

    g "Nevím co se s nimi stalo, ale už jsem o nich nikdy neslyšela."


    show mary dark crying

    g "Trvalo to týden a potom to skončilo. Moje sestry... moji\
       rodiče... ti všichni..."

    g "Teď už jsem zbyla jenom já."

    p "To je mi líto."

    "Nevěděl sem co jiného bych mohl říct dívce, která ztratila\
     svou rodinu a byla z toho očividně zlomená."

    show mary dark sad

    "Přikývla na odpověď, utřela si slzy a potom jsme znovu\
     začali kráčet v tichu."

    jump walking_again

label dropped_it:

    "Vypadalo to, že kdybych ji požádal ať pokračuje, začala by plakat.\
     Tak jsem se rozhodl nechat to tak a začal jsem místo toho znovu\
     jít po pláži."


# 52 lines.
label walking_again:

    scene beach3 with dissolve
    $ persistent.unlock_dark = True

    "Nevím kolik času uběhlo, než jsme znovu promluvili. Možná to byla\
     hodina, možná míň, možná víc."

    "Pomalu jsme pokračovali v naší cestě kolem ostrova se mnou kráčejícím\
     o několik kroků pozadu."

    "Kdyby to byl někdo jiný pravděpodobně bych se otočil a vyrazil\
     zpátky domů."

    "Ale bylo tu něco kolem té dívky, co způsobilo že jsem chtěl zůstat\
     s ní."

    "Možná nějaký druh aury. Nebo krása? Tragédie? Osamělost?\
     Asi kombinace těch všech a něco navíc."

    "A tak jsme tiše kráčeli měsícem ozářenou pláží."


    "Konečně už sem to nemohl déle vydržet a znovu jsem zkusil\
     dát se do rozhovoru."

    show mary dark wistful with dissolve

    p "Tak... je tu něco co bys chtěla dělat ve svém životě?"

    "Pár vteřin nic neříkala, jako kdybych řekl něco špatně."

    "Ale pak začala mluvit."

    show mary dark smiling

    g "Kdysi sem myslela, že vím."

    g "Když sem byla mladší, bylo to jako kdyby můj život byl\
       pro mě už naplánovaný. Šla bych v matčiných stopách."

    g "Pomáhala bych pár let na farmě. Už když jsme byli mladí tak\
       jsme museli pomáhat, ale jak bychom dokončili vzdělávání\
       mohli bychom pomáhat ještě víc."

    g "Nakonec bych potkala milého hocha. V té době jsem nevěděla koho,\
       ale nejspíš by to byl některý z Millerových chlapců. Ti byli\
       v mém věku."

    g "Oženili by jsme se a založili vlastní farmu."

    g "Spolu bychom vychovávali rodinu. Pár děvčat a já sem si\
       vždycky přála kluka, protože všechno co jsem měla byly sestry."

    show mary dark wistful

    g "Ale teď..."

    "Její úsměv zmizel jak nechala myšlenku vytratit se. Po krátké\
     chvíli vrátila téma zpátky ke mě."

    g "A co ty? Jaké máš plány do budoucna?"

    "Její otázka mně zastihla trochu nepřipraveného, jak proto že jsem nečekal,\
     že se zeptá mě na to samé a taky protože jsem o své budoucnosti moc neuvažoval."

    show mary dark smiling

    "Trochu se usmála na mé očividné zmatení."

    p "No teď trávím léto na návštěvě u rodiny. Když skončí budu chodit do školy."

    g "Nejsi už trochu starý na to být ještě ve škole?"

    p "No, státní škola... Od podzimu budu navštěvovat univerzitu."

    p "Nevím co přesně budu dělat potom... Ještě přesně nevím jaké\
       přednášky budu navštěvovat nebo z čeho budu graduovat."

    p "Hádám, že když nebudu studovat, budu načas žít s rodiči."

    p "Nakonec si najdu práci a odstěhuju se."

    p "Pokud jde o usazení se a založení rodiny... no netuším kdy\
       se to stane."

    p "Ve skutečnosti jsem o tom moc nepřemýšlel. Nemyslím si, že\
       hodně lidí má svoje životy naplánované tak dobře jako ty."

    p "Myslím, že většina lidí životem prostě tak nějak proplouvá."

    show mary dark laughing

    "V tom okamžiku se tiše zasmála."

    p "Je na tom něco směšného?"

    show mary dark smiling

    g "Ne, ne, vůbec nic. Ve skutečnosti tě obdivuju."

    p "Proč?"

    g "No, můžeš se svým životem udělat cokoliv. Můžeš jít kam jen chceš."

    g "Někteří lidé lidé by si mysleli, že mít příliš mnoho možností\
       je nějaké prokletí nebo přítěž."

    g "Ale já si myslím, že je to prostě svoboda a to je dobrá věc."

    g "Myslím, že je hezké žít život, kde je tvá budoucnost otevřená,\
       kde můžeš dělat cokoliv jen chceš."

    "Znovu jsem nevěděl co říct a na chvilku jsem si myslel, že se\
     vrátíme k chůzi potichu."

    "Ale místo toho, aby přerušila rozhovor, pokračovala."

    g "Co děláš pro zábavu?"

    p "Spoustu věcí. Mám rád kreslení, poslouchání hudby a\
       sledování kreslených filmů a fotbalu v televizi."

    show mary dark confused smiling

    g "Fot...balu?"

    "Opakovala výraz pomalu, jako kdyby znala obě slova, ale nikdy\
     předtím je neslyšela dohromady.\n(pozn: fotbal je v angličtině football, foot - noha, ball - míč)"

    p "Jasně fotbal. Víš sport... slyšela jsi o něm, že?"

    "Zavrtěla hlavou, aby naznačila že ne."

    p "Jak začít s jeho popisem?"

    p "Na hřišti jsou najednou dva týmy a jeden z nich má míč.\
       Center předá míč quartebackovi."

    p "Quarteback může buď hodit míč dalšímu hráči, předat ho dalšímu nebo\
       s ním zkusit běžet."

    "Zdá se, že všechno co jsem řekl ji ještě více mátlo. Ale nevěděl jsem\
     co jiného dělat a tak jsem pokračoval."

    p "Druhý tým se snaží zastavit je sražením hráče s míčem. Pokud se\
       jim nepodaří pohnout s míčem o 10 yardů ve čtyřech pokusech,\
       potom ho dostane druhý tým..."

    show mary dark laughing

    "Bylo to v této části mého vysvětlování, když se začala chichotat.\
     Když o tom teď přemýšlím moje vysvětlení bylo svým způsobem absurdní."

    hide mary with dissolve

    "A tak jsme strávili noc mluvením o různých věcech."

    "Většinou jsem mluvil a ona poslouchala. Občas se mě na něco\
     zeptala a já odpověděl jak nejlépe jsem uměl."

    "Mnohokrát to nestačilo a tak se často rozesmála jak sem se\
     zapletl do vysvětlování."


    "Tak jsme strávili celou noc mluvíc a smějíc se, jak jsme\
     obcházeli celý ostrov."

    $ renpy.music_start('softwaves.ogg')
    scene dawn1 with dissolve
    show mary dawn smiling with dissolve


    "Za úsvitu jsme měli cestu téměř za sebou, až k útesu kde jsme\
     se poprvé setkali."

    "Začala šplhat dolů zpátky na pláž, ale já jsem ji zastavil."

    show mary dawn confused smiling

    p "Myslel jsem, že by jsme tu mohli zůstat a pozorovat východ slunce."

    show mary dawn confused wistful

    "K mému překvapení, její reakce na moje vysvětlení bylo vylekání."

    g "To už je úsvit? Musím jít."

    "To bylo pro mě překvapení. Vycházeli jsme spolu dobře a teď to\
     vypadalo jako by chtěla utéct."

    show mary dawn wistful

    "Musela vidět zklamání na mé tváří, jak změnila tón a vysvětlovala."

    g "Není.. není to kvůli tobě, já bych ráda... ale je to tak... že...\
       že nemůžu."

    p "Rozumím."

    "Řekl jsem, že rozumím, ale nic jsem nechápal."

    hide mary with dissolve

    "Jak začala odcházet, začal jsem přemýšlet jestli je tu něco\
     co bych mohl říct, abych ji tu zdržel ještě chvilku."

    "Najednou jsem si vzpomněl, že je tu něco na co sem se jí zapomněl zeptat."

menu menu_3:
    '"Jak se jmenuješ?"':

        "Uvědomil jsem si, že za celou noc sem se jí nezeptal, jaké\
         je její jméno. Je mým zlozvykem, že můžu s někým vést\
         celou konverzaci, aniž bych znal jeho jméno."

        "A tak sem se jí zeptal, skoro na ni křičíc tu otázku."

        show mary dawn smiling with dissolve

        "Zastavila, otočila se na mě a usmála se."

        g "Jmenuju se Mary... Mary Harperová!"


    '"Kdy tě můžu znovu vidět?"':

        "Uvědomil sem si, že nevím kdy bych ji mohl znovu vidět. Kdybych\
         to nevěděl, tak bych ji asi už nikdy nespatřil."

        show mary dawn smiling with dissolve

        "Na chvilku zastavila, přemýšlejíc a potom mě nakonec odpověděla."

        g "Můžeš mě znovu potkat v noci o příštím úplňku."

        p "Příštím úplňku? To se neuvidíme alespoň měsíc. Nemůžeme\
           se setkat před tím?"

        show mary dawn wistful

        g "Promiň... to je prostě čas..."

        p "Rozumím. Budu na tebe čekat na místě kde jsme se poprvé setkali."

        $ meet_again = True

# Fade to bright yellow, then fade to black.
scene yellow with dissolve
scene black with slowdissolve

"V tu chvíli slunce prozářilo obzor. Jeho jas mě oslepil a já jsem\
 reflexivně zavřel oči."

"Viděl jsem východ slunce mnohokrát předtím a potom, ale nikdy tak jasný jako tenkrát."

scene dawn2 with dissolve
$ persistent.unlock_dawn = True

"Když jsem otevřel oči byla pryč."

"Nevěděl jsem proč odešla, jak odešla tak rychle nebo kam šla."

"Jediné co jsem věděl bylo, že jsem se s ní chtěl znovu setkat."

if meet_again:
    jump second_day

label ending2:

    "Protože jsem zjistil její jméno pokračoval jsem v jejím hledání\
    na webu."

    "Samozřejmě, jméno \"Mary Harperová\" mě dalo tisíce výsledků."

    "Ale po tom co jsem to omezil na místní oblast, nedostal jsem\
     vůbec žádné."

    "Podle online telefonního seznamu nikdo s příjmením \"Harper\" nežil\
     na ostrově."

    $ renpy.music_start('cars.ogg')
    scene library with dissolve

    "Po tom co jsem se trochu vyspal, vyrazil jsem do knihovny,\
     abych o ní zkusil zjistit víc."

    "Protože řekla že byla odsud, půjčil sem si knihu o historii\
      North Sand Islandu."

    if family_history:

        "Měl jsem za to, že rodina vyhlazená nemocí by stála za\
         zaznamenání."

    "Jediná věc co jsem našel, když sem vyhledal \"Harper\" v knize\
     byl příběh Harperovy rodiny co žila na ostrově kolem roku 1780."

    "Byli vyhlazeni epidemií, která zabila téměř všechny na ostrově\
     roku 1790. Jen několik chlapců uniklo, aby o tom mohli vyprávět."

    "Ta zanechala ostrov prázdný a teprve až po občanské válce se\
     tu znovu usadili lidé."

    if family_history:

        "Je podivné jak podobná byla jejich situace tomu co se stalo\
         Mary."

        "Otec, matka a tři dcery všichni vyhlazení nemocí."

        "Spolu se všemi ostatními na ostrově."

        "Ale samozřejmě to musela být shoda náhod, protože se to stalo\
         před více než dvěma sty lety."


        "Nepodařilo se mi najít nic jiného a tak sem to nakonec vzdal."

    else:

        "Prohledal jsem knihu a prošel záznamy lidí žijících na\
         ostrově po tom co byl znovu obydlen."

        "I přes hodiny strávené hledáním se mě nepodařilo najít nikoho,\
         kdo by se jmenoval Harper."


    $ renpy.music_start('waves.ogg')
    scene beach1 nomoon with dissolve

    "Té noci jsem šel zase ven na pláž, doufajíc že ji znovu potkám."

    "Strávil jsem tam celou noc, ale ona se neobjevila."

    "Zkusil sem to další noc a potom další. Každou noc po dva týdny."

    "Ale po té první noci jsem ji už nikdy nespatřil."

    "Ale také jsem na ni nikdy nezapomněl."


    # .:. Ending 2 - History.
    $ ending = 2, "Historie"
    $ persistent.unlock_2 = True
    jump ending


label second_day:

    "Trvá to dvacet devět dní od úplňku k úplňku a tak dlouho jsem\
     musel čekat před tím než jsem ji mohl znovu vidět."

    "Byl by to opravdu dobrý příběh, kdybych mohl říct, že jsem strávil\
     celou tu dobu myšlenkami na ni, ale tak to v životě nefunguje."

    "Jsem si jistý, že jsem během toho měsíce dělal i jiné věci,\
     ale když na to vzpomínám, jen těžko si je vybavuji."

    "Strávil jsem hodně času myšlenkami o ní a vzpomínáním na\
     její úsměv a smích."

    "Nadávajíc sám sobě za to, že jsem se zapomněl zeptat na její jméno."

    "Pořád znovu a znovu kontrolujíc přesný čas dalšího úplňku, abych\
     si byl jistý, že se tam objevím ve správnou noc."

    $ renpy.music_start('waves.ogg')
    scene beach1 with dissolve

    "A nakonec tu byla ta noc a já jsem znovu stál na pláži,\
     dívajíc se na měsíc."

    g "Čekals dlouho?"

    show mary dark smiling with dissolve

    "Otočil jsem se a zjistil, že stojí vedle mě."

    g "Ve skutečnosti jsem ani nečekala, že tu budeš. Je vzácné, že\
       se tu někdo objeví podruhé."

    p "Hej, přece jsem říkal ,že přijdu, že?"

    g "Říkals."

    p "Jsem ten druh chlapa co drží slovo. Když řeknu, že někde budu,\
       tak tam budu."

    p "A stejně co bych to byl za zač, abych nepřišel vidět tě znovu."

    p "Nebo neslyšelas co jsem minule říkal? Odešlas v tak strašném\
       spěchu, že jsem se tě ani nestačil zeptat na jméno."

    g "Mary."

    m "Jmenuju se Mary Harperová."

    p "No Mary Harperová je hezké tě znovu vidět skoro po měsíci."

    show mary dark wistful

    m "Taky tě ráda vidím, i když mě to připadá jako by to bylo včera."

    "Nebyl sem si jistý co přesně tím myslela, a tak jsem řekl\
     co jsem si předtím myslel."

    p "Myslím, že pro mě to bylo stejné. Strávil jsem celý měsíc\
       přemýšlením o tobě."

    show mary dark smiling

    m "Nejsem si jistá, že to bylo stejné... ale je to milé."

    "Nevěděl sem co na to říct a tak sem mlčel."

    "Místo toho jsem ukázal směrem k pláži a začali jsme kráčet\
     spolu po pobřeží."

    scene beach2 with dissolve

    "Nebylo to dlouho před tím než Mary prolomila ticho a\
     položila mi otázku."

    show mary dark smiling with dissolve

    m "Už sem ti trochu řekla o své rodině... ale nezeptala sem se\
       tě na tvou. Jaká je tvoje rodina?"

    p "Když jsem tady na ostrově, tak žiju s tetou a strýcem ale doma mám\
       otce, matku a sestru."

    m "Sestru? Je mladší nebo starší?"

    p "Je o dva roky mladší než já."

    m "Vycházíte spolu dobře?"

    "Na vteřinu jsem uvažoval o její otázce a pak jsem se rozhodl,\
     že čestnost bude nejlepší taktika."

    p "Ani ne. Hádáme se spolu jako kočka a pes."

    show mary dark laughing

    "Na tohle se lehce zasmála."

    show mary dark smiling

    m "A kvůli čemu se hádáte?"

    p "No to nikdy není kvůli dvěma těm samým věcem. Dej nás dva spolu\
       do místnosti na pár hodin a najednou se něco objeví... a už jsme\
       v tom zase."

    "Byl jsem si jistý, že nechci pokračovat o tom jak se se sestrou\
     pořád hádáme a tak jsem potřeboval najít způsob jak o tom\
     přestat mluvit."

    if family_history:

        p "Jak vycházelas se sestrami ty?"

        show mary dark wistful

        "Na chvilku jsem litoval své otázky, když jsem si vzpomněl\
         jak se málem rozplakala, když naposled mluvila o své rodině."

        show mary dark smiling

        "Ale tentokrát se zdála šťastná, že o tom může mluvit."

        m "Moje sestry a já... byly jsme nejlepší přátelé."

        m "Skoro jsme musely být, protože náš dům byl velice malý."

        m "Až do mých sedmi let jsme dokonce spaly v jedné posteli."

        m "Ale dělaly jsme všechno spolu. Když jsme měly nějakou práci,\
           tak jsme pomáhaly jedna druhé a stihly jsme ji za\
           poloviční čas."

        p "Hráli jste si spolu často?"

        m "To ano! Taťka nám vyrobil domeček pro panenky a mamka nám\
           udělala panenky a společně jsme si s nima hrály."

        m "Hráli jsme si na dům. Karen byla otec, já matka a Alice\
           byla naše dcera."

        m "Zpívaly jsme a rozesmávaly jsme jedna druhou. Nesmála jsem se\
           tak od..."

        show mary dark wistful

        m "No, od té doby co jsme se minulý měsíc potkali."

        "Zaslechl jsem tesklivý tón v jejím hlase a rozhodl jsem\
         se nechat tématu. Znovu jsme vyrazili, kráčejíc po pláži."

    else:

        show mary dark confused smiling

        p "Podívej se támhle!"

        hide mary

        "Zavolal jsem první věc co mi přišla na mysl a rozběhl sem\
         se po pláži."

        "Následovala, běžíc za mnou."

        "Po chvíli jsem zpomalil a nechal ji, aby mě dohnala."


        show mary dark laughing with dissolve

        m "Mám tě!"

        "Řekla, smějíc se jak chytila moje tričko."

        hide mary with dissolve

        "A tak jsme spolu pokračovali v chůzi po pláži."

    scene beach3 with dissolve

    "Jak šla noc mluvili jsme o spoustě věcí. Abych byl upřímný,\
     nevzpomínám si o čem všem jsme se bavili."

    "Co mi z ní zůstalo byly pocity."

    "Vůně soli z mořského vzduchu."

    "Zvuk vln narážejících na pobřeží."

    "Způsob jakým měsíční svit rozzařoval její pokožku."

    "To jak jsem cítil písek, když jsem zakopl o kámen a upadl."

    "Teplo její ruky, když se natáhla a pomohla mi zpátky na nohy."

    show mary dark wistful with dissolve

    m "Jsi v pořádku?"

    p "Myslím že ano. Písek byl měkký."

    show mary dark smiling

    m "To jsem ráda. O co jsi to zakopl?"

    p "Myslím, že to byl kámen, nebo tak něco."

    "Podíval jsem se na míst, kde jsem upadl. Byly tam kameny,\
     příliš mnoho na to, aby bylo těžké určit jeden z nich."

    m "Dávej pozor. Nechtěla bych aby ses zranil."

    "Přikývl jsem, naposled se podíval na kameny a otočil se\
     aby jsme mohli znovu vyrazit. Ale právě v tu chvíli jsem\
     zahlédl zlatý záblesk."

    "Šel sem k místu, kde jsem viděl ten záblesk a začal jsem kopat.\
     Po pár vteřinách ke mě přišla Mary."

    show mary dark confused smiling

    m "Našels něco?"

    p "Já ne..."

    "Chtěl sem říct, že nevím, ale pak jsem se zarazil, protože jsem\
     našel co jsem hledal."

    "V mých rukách byl zlatý prstýnek. Podal jsem ho Mary, ať se na něj\
     podívá."

    p "Je to prstýnek."

    "Prohlédl sem si ho trochu podrobněji. Byl příliš lehký na to, aby\
     byl celý ze zlata a na pár místech byly škrábance, kde bylo\
     pozlacení odřené."

    "Předal jsem ho Mary ať si ho může lépe prohlédnout."

    show mary dark smiling

    m "Je nádherný."

    p "Není pravý. Někdo vzal kovový kroužek a dal na něj zlato, aby\
       vypadal hezčí."

    m "Ale je tak pěkný."

    p "Jestli se ti líbí, tak si ho můžeš nechat."

    show mary dark vhappy

    m "Opravdu?"

    p "Jistě."

    m "Můžeš mi ho nasadit?"

    "Nemusel jsem na to odpovídat, jak nastavila ruku. Vzal sem ho\
     a nasunul na její prst. Padnul perfektně."

    m "Díky."

    hide mary with dissolve

    "A s tím chytila mou ruku a spolu jsme vyrazili po pláži."

    $ renpy.music_start('softwaves.ogg')
    scene dawn1 with dissolve

    "Než sem se nadál byl úsvit a my jsme byli na tom samém místě\
     jako před měsícem."

    p "Mohla bys tentokrát zůstat a sledovat úsvit se mnou?"

    show mary dawn wistful with dissolve

    m "Promiň... nemůžu."

    p "No a kdy tě můžu znovu vidět?"

    m "Můžu se s tebou setkat jen v noci, když je úplněk."

    "I když jsem čekal že to může říct, stejně bolelo slyšet to.\
     Nevěděl jsem, jak vydržím celý měsíc bez toho abych ji viděl."

    p "Jak to? Proč tě nemůžu vidět dřív?"

    m "Protože jsem duch."

    "Řekla to, jako kdyby to byla ta nejsamozřejmější věc na světě,\
     jako kdyby říkání ti, že je duch bylo něco, co se stává každý\
     den."

    "Nevěděl sem co na to říct a tak sem tam tiše stál."

    "Nakonec, Mary se rozhodla to rozvést a říct mi svůj příběh."

    m "Stala jsem se duchem po tom co jsem zemřela... Umřela jsem\
       spolu s rodinou při epidemii co zasáhla ostrov, když mi bylo\
       deset."

    m "Z nějakého důvodu jsem se vrátila za úplňku. Prostě jsem\
       zjistila, že jsem tady na ostrově."

    m "Vrátila jsem se znovu o dalším úplňku a potom o dalším a pokud\
       vím tak všechny následující. Vždycky se vracím za noci o úplňku."

    m "V noci můžu dělat co chci, ale když vyjde slunce, všechno\
       ztmavne a najednou je další měsíc."

    m "Už je to tak po stovky let."

    m "Nějaký čas sem se nudila, ale nakonec se lidé vrátili na ostrov.\
       Jednou za čas mě někdo potkal, tak jako ty."

    m "Nějakou chvíli jsme mluvili. Ale většina z nich se mnou chtěla
       mluvit jenom proto, že jsem byla duch."

    m "Po čase vždycky odešli. Hádám, že je tu toho jenom tolik,
       kolik se o tom dá říct."

    show mary dawn confused wistful

    m "Když o tom přemýšlím ty ses na to nikdy nezeptal. Přišels
       na to sám?"

    menu menu_4:

        '"Samozřejmě sem to věděl."':

            "V pohledu zpět to bylo očividné. Způsob, jakým zmizela
             za úsvitu, to jak nevěděla nic o věcech o kterých dnes
             ví každý..."

            "Ale bylo potřeba mě to říct, abych si konečně poskládal
             dílky dohromady a přijal to."

        '"Netušil jsem to."':

            show mary dawn smiling

            m "Vážně? Obvykle na to lidé přijdou během první noci."

            m "To je jediný důvod proč se lidé vrací. Vrátí se a
               mluví s duchem, až dokud neztratí zájem."

            show mary dawn vhappy

            "Troch se zasmála a potom tom vypadalo, že si něco uvědomila."

            m "To znamená... že tu nejsi, protože já jsem duch?"

            m  "Vrátil ses proto, že ses rozhodl být se mnou?"

            "Opět jsem byl beze slov a tak jsme tam chvíli stáli."

    show mary dawn wistful

    "Nakonec přerušila ticho."

    m "Slunce už skoro vyšlo a já musím jít."

    p "Nechoď."

    show mary dawn confused wistful

    m "Ale..."

    hide mary with dissolve

    "Chytil sem její ruku a přitáhl ji k sobě."

    p "Zůstaň se mnou a sleduj východ slunce."

    "Potom už jsme nic neříkali. Prostě jsme tam stáli, ruku v ruce,\
     sledujíc jak se obloha projasňuje."

    "Cítil jsem její levou ruku v mé pravé, jak jsme tam stáli hledíc\
     přes oceán."

    scene dawn2 with dissolve

    "A jak slunce stoupalo najednou byla moje pravá ruka prázdná."

    "Otočil jsem se, abych se podíval, ale dívka co tam stála byla pryč."

    p "Hádám, že byla opravdu duch."

    "Řekl jsem jen tak nikomu určitému. Řekla mi to a já sem jí věřil,\
     ale dokud nezmizela byl tu malý stín pochyb."

    "Strávil jsem ráno stojíc na útesu přemýšlením o tom."

    menu menu_5:

        "A nakonec jsem si uvědomil,"

        "že ji musím osvobodit.":

            jump ending3

        "že to není důležité.":

            jump ending4

##############################################################################
# Ending 3

label ending3:

    "Uvědomil sem si, že to není přirozené pro někoho jako je Mary být\
     uvězněn na stovky let jako duch, odsouzený objevovat se jenom v noci\
     o úplňku."

    "A přes moje city k ní jsem přišel k závěru, že to nejlepší co\
     pro ni můžu udělat je pomoci jí najít pokoj."

    $ renpy.music_start('cars.ogg')
    scene library with dissolve

    "Strávil jsem celý měsíc výzkumem v malé ostrovní knihovně."

    "Prošel jsem každou knihu kterou měli o okultismu. Duchové,\
     magie, čarodějnictví... a tak podobně."

    "Přečetl jsem jednu nebo dvě knihy denně."

    "Když jsem skončil s knihami, které měla ostrovní knihovna musel\
     jsem si je objednat z pevniny."

    "Zašlo to až tak daleko, že většina knihovníků mě znala jménem\
     a ten zbytek mě znal podle pověsti jako vysokoškoláka posedlého\
     okultismem."

    "S knihami to bylo tak, že většina jejich obsahu byla vymyšlená,\
     ale hluboko pod povrchem některé z nich obsahovaly zrnko pravdy."

    "Jediný způsob jak jsem ho mohl najít byl přečíst všechno co jsem\
     mohl o tématu a zjistit co mají společného."

    "Další úplňkové noci jsem byl připravený uvést v praxi co jsem se naučil."

    $ renpy.music_start('waves.ogg')
    scene beach1 with dissolve
    show mary dark smiling with dissolve

    "Vrátil jsem se na místo, kde jsme se setkali předchozí dvě noci a\
     sledoval, jak se vlny pomalu převalují."

    "Mary tam byla, čekajíc na mě."

    m "Vrátil ses."

    p "Neplánoval jsem nechat tě samotnou po tom všem."

    "Nic na to neřekla."

    p "Tak co dnes večer budeme dělat."

    m "Obvykle trávím noc procházením se kolem ostrova, jako jsme to\
       dělali předchozí noci."

    p "Aha. Takže, můžu tě doprovodit?"

    m "Jistě."

    hide mary with dissolve

    "Vzala mě za ruku a vyrazili jsme na naši obvyklou cestu\
     kolem ostrova."

    scene beach2 with dissolve

    "Nemluvili jsme tolik jako předtím. Nepotřebovali jsme. Prostě\
     být v přítomnosti toho druhého stačilo."

    "Chlad vzduchu kontrastoval s teplem její pokožky."

    "Kdo by čekal, že duch může být tak teplý?"

    "Měli jsme několik krátkých rozhovorů, abychom si ukrátili čas."

    "Ale většinu času jsme kráčeli v tichu. Předchozí události na nás\
     těžce ležely, jak jsme oba čekali na toho druhého, až něco udělá."

    "Nakonec už jsem to nemohl vydržet a zeptal jsem se jí na to co\
     jsem potřeboval vědět."

    show mary dark smiling with dissolve

    p "Mary, je tu něco cos chtěla udělat, ale nikdy nemělas tu možnost?"

    "Klíč pochopení, jádro pravdy které jsem objevil ve všech těch\
     knihách bylo, že věc která vytvoří ducha je lítost."

    show mary dark confused smiling

    m "Co tím myslíš?"

    p "Nevím... Je tu něco cos chtěla udělat, ale nemohlas?"

    show mary dark wistful

    "Chvíli nad tím přemýšlela."

    "Nakonec odpověděla téměř neslyšným šepotem."

    m "Chtěla jsem být nevěsta."

    "Věděl jsem to."

    "Udělal sem seznam věcí, kterých by Mary mohla litovat a tato\
     byla na vrcholu seznamu."

    "Řekla, že její sen byl vdát se... dokonce i její oblečení vypadalo\
     jako svatební šaty."

    "Věděl sem, že ji miluji a byla tu jen jedna věc, kterou jsem\
     mohl udělat. A tak sem si klekl na koleno a řekl,"

    p "Mary Harperová vezmeš si mě?"

    show mary dark confused wistful

    "Byla tím omráčená... a stála tam chvíli a nic neříkala. Nakonec\
     promluvila."

    m "Jsi si jistý... jsi si jistý, že se chceš oženit... se mnou?"

    p "Tak jistý jak jen to jde."

    show mary dark vhappy

    m "Potom... Ano!"

    show mary dark confused smiling

    "Vstal sem a objali jsme se. Ale stále byla trochu zmatená."

    m "Ale jak to uděláme? Já můžu být venku jenom v noci a nemyslím\
       si, že duchovní by provdal ducha."

    p "Neboj, můžeme mít svatbu ve zvykovém právu."

    m "Zvykovém právu?"

    p "Tak dlouho, jak říkáme, že jsme manželé a vyměníme si sliby tak\
       se to počítá."

    show mary dark vhappy

    m "Opravdu? Tak kdy se můžeme oženit?"

    p "Pokud jsi připravená, tak to můžeme udělat hned."

    m "Jsem!"

    p "Tak udělejme tohle."

    "Vytáhl jsem ze zadní kapsy sešit obsahující svatební sliby,\
     které jsem připravil."

    show mary dark smiling

    "Změnil jsem hlas, aby zněl jako nějaký druh duchovního a začal\
     jsem číst."

    pm "Bereš si tuto ženu za svou právoplatnou manželku a budete spolu\
        žít od dnešního dne ve zlém i dobrém, v bohatství i chudobě, v nemoci\
        i ve zdraví, na dobu co budete oba existovat?"

    menu menu_ido:
        "Svým normálním hlasem jsem odpověděl,"

        '"Ano beru."':

            pass

    "Otočil sem se k Mary a opakoval slib pro ni."

    pm "Bereš si tohoto muže za svého právoplatného manžela a budete spolu\
        žít od dnešního dne ve zlém i dobrém, v bohatství i chudobě, v nemoci\
        i ve zdraví, na dobu co budete oba existovat?"


    m "Ano beru."

    "Chvíli jsme tam stáli, před tím než jsem konečně pokračoval."

    p "No a je to. Jsme manželé. Všechno co zbývá je polibek."

    "Přišla ke mě a objali jsme se."

    scene black with dissolve

    "Zavřel sem oči, čekajíc na její rty."

    m "Děkuju."

    "Slyšel jsem jak zašeptala a cítil sem teplo jejích rtů jak\
     se dotkly mých."

    "Potom už jsem necítil nic jen chladný noční vzduch."

    scene beach2 with dissolve

    "Když jsem otevřel oči byl jsem sám."

    $ renpy.music_start('frogpond.ogg')
    scene littlemary

    lm "Fuuuj!"

    "Moje vnučka přerušila mé vyprávění příběhu."

    lm "Tys políbil někoho jiného než babičku!"

    lm "Ty ses {i}oženil{/i} s někým kdo nebyla babička!"

    p "No to bylo před tím než jsem potkal tvou babičku."

    p "Ve skutečnosti, tak jsem potkal babičku. Pracovala jako\
       stážistka v knihovně."

    p "Po tom už jsem Mary nikdy znovu neviděl."

    "Zdá se nepřesvědčená."

    lm "Byl to skutečný příběh?"

    p "Máš moje slovo."

    "Chvíli nad tím přemýšlela, před tím než odpověděla."

    lm "Nevěřím ti. Řekni mi další příběh."

    p "Dnes večer už ne. Je čas jít spát."

    lm "Ale!"

    p "Žádné ale, teď už je vážně čas jít spát."

    scene black with dissolve

    "Vypnul jsem světla, tak aby konečně mohla jít do postele."

    "Kdybych to neudělal, moje vnučka by zůstala vzhůru celou noc\
     a nešla by si lehnout."

    "Moje vnučka Mary, jejíž jméno jsem navrhl zeťovi, zatímco jsme\
     čekali v nemocnici."

    "Moje vnučka pojmenovaná po dívce, se kterou jsem byl ženatý\
     jen několik okamžiků na měsícem ozářené pláži, před dávnou dobou."

    # .:. Ending 3.
    $ ending = 3, u"Manželé na chvíli"
    $ persistent.unlock_3 = True
    jump ending



##############################################################################
# Ending 4

label ending4:

    $ renpy.music_start('waves.ogg')
    with None
    scene beach1
    show mary dark wistful
    with dissolve

    "O měsíc později jsem s vrátil na pláž. Tentokrát na mě Mary\
     čekala."

    p "Hej."

    m "Vítej zpátky. Předpokládám že pro mě máš pár otázek.\
       Každý má."

    p "Já ne."

    show mary dark confused wistful

    "To ji zarazilo v chůzi."

    m "Nemáš žádné otázky? Nezáleží ti na tom co jsem?"

    p "Co jsi? Co tím myslíš."

    m "Víš... duch."

    p "To není to čím pro mě jsi."

    show mary dark confused smiling

    p "Pro mě jsi dívka se kterou chci být. Dívka kterou miluji."

    show mary dark smiling

    p "Mimo to pro mě nic neznamená jestli jsi duch nebo jesli já\
       jsem šotek."

    p "To všechno není důležité."

    p "Všechno co je pro mě důležité je, že ty jsi ty, já jsem já a\
       to že jsme spolu."

    hide mary with dissolve

    "S tím jsem znovu začal kráčet po pláži. Musela tím být příliš\
     omráčená, protože chvíli stála na místě."

    "Nakonec jsem se k ní otočil a zeptal se:"

    p "Tak jdeš?"

    show mary dark vhappy with dissolve

    m "Ano!"

    "Zakřičela na odpověď a rozběhla se směrem ke mě."

    "Spolu jsme se vydali na další měsícem ozářenou procházku po pláži."

    hide mary with dissolve

    "Od té noci jsme strávili každý úplněk spolu."

    "Odešel jsem na univerzitu, ale vždycky jsem si našel čas zajet\
     na ostrov, abychom mohli strávit noc spolu."

    "Moje první zaměstnání bylo na pevnině, kousek od ostrova. Vždycky\
     jsem si plánoval volno tak, abych měl dost času dostat se na pláž\
     před tím, než se Mary objevila."

    "Nakonec jsem našetřil dost peněz na domek na pláži, kousek od\
     místa kde jsme se poprvé setkali."

    "Potom jsem si založil softwarovou konzultační firmu ve svém domě.\
     Stačilo to na zaplacení účtů a co bylo důležitější, mohl jsem\
     si vždycky udělat volno, když bylo kolem úplňku."

    "Nikdy jsem nevynechal tu noc. Byl jsem tam ať už bylo hezky nebo\
     pršelo. Jednou dokonce sněžilo a jednou jsem musel projít cestou za\
     hurikánu."

    "Mary jednou řekla, že je hezké, že můžu naložit se svým životem jakým\
     jen chci způsobem. No, já jsem věděl co chci a to bylo strávit život s ní."

    "Spolu jsem slavili moje narozeniny sedmdesátkrát a její\
     dvakrát. Nikdy jsme nevynechali noc spolu."

    "Nikdy, až do dneška."

    $ renpy.music.play('heartbeat.wav', loop=True, fadeout=.25)
    scene hospital1 with dissolve
    # Music heartbeat

    "Umírám."

    "Není to tak špatné jak to zní. Je mě osmdesát osm a hádám,\
     že prostě nadešel můj čas."

    "Moje srdce vynechávalo a já sem řekl doktorům, aby nic nedělali\
     když nakonec přestane tlouct."

    "Mám nějaké výčitky? Ani ne."

    "Někteří lidé by si mohli myslet, že bych mohl litoval toho, že jsem\
     se neoženil a neměl děti."

    "Ale mě stačila Mary, i když jsme se nikdy neoženili."

    "A kromě toho jsem použil peníze, které sem vydělal, na školu\
     pro děti a vnoučata mé sestry a zbylo toho dost, aby všichni měli\
     hezké dědictví."

    "Zbytek jsem nechal pro charitu. Myslím, že starání se o rodinu\
     a svět je stejně dobrý přínos pro potomky, jako každý jiný."

    "Ale je tu přece jenom jedna věc, které lituju a to je, že dnes\
     naposledy nebudu mít možnost vidět Mary."

    "Dnes v noci je úplněk, ale já jsem připoután na nemocniční\
     lůžko, neschopný sám se pohnout."


    "Konec už je nablízku."


    "Moje vnímaní světa se zakaluje a já se více a více soustředím\
     na moje tělo, které začíná vynechávat."

    # Stop music
    $ renpy.music.queue('heartbeat.wav', loop=False)

    "Cítím, že moje srdce tluče slaběji a slaběji."

    # Play 1 heartbeat.
    $ renpy.music.queue('heartbeat.wav', loop=False)

    "Buch ..."

    # Play 1 heartbeat.
    $ renpy.music.queue('heartbeat.wav', loop=False)

    "... buch ..."

    "..."

    "......"

    "Nakonec zastavuje úplně a já si uvědomuji, že konec je přede mnou."

    scene hospital3 with slowdissolve

    "Byl jsem připravený tomu čelit sám, ale teď zjišťuju, že\
     nebudu muset. Mary tu stojí se mnou."

    "Nevím proč nebo jak... ale vím že je tady."

    m "Co je důležité... je to že jsme spolu."

    scene heaven with slowdissolve

    "Svět se stává bílým a cítím, že mě léta opouštějí."

    "Teď už můžu vidět Mary. Z nějakého důvodu jde směrem ode mě."

    "Po pár vteřinách se otáčí a ptá se:"

    m "Tak jdeš?"

    "Utíkám k ní a nějak ji chytám za ruku."

    "Spolu vcházíme do světla."

    scene white with slowdissolve

    # .:. Ending 4.
    $ ending = 4, u"Spolu do světla"
    $ persistent.unlock_4 = True
    jump ending

label ending:

    scene black with slowdissolve

    $ ending_number, ending_name = ending

    ".:. Konec %(ending_number)d: %(ending_name)s"

    if ending_number in (3, 4, 0):
        scene good_ending
    else:
        scene bad_ending


    python hide:

        renpy.music_start('end_theme.ogg', 0)
        renpy.transition(slowdissolve)

        text = u'"Procházky za měsíčního svitu"\n"Moonlight Walks"\n\n'
        text += u'Příběh, grafika, a programování PyTom.\n'
        text += u"Poháněno Ren'Py.\n\n\n\n\n\n\n"
        text += u'Poděkování patří přispěvatelům na Lemma Soft Forums\nza jejich podporu a rady.\n\n'
        text += u'Díky za hraní!\n\n'


        # minutes, seconds = divmod(int(renpy.get_game_runtime()), 60)
        # text += u'Trvalo ti %d:%02d k dosažení konce %d.' % (minutes, seconds, ending_number)


        # text += u'Copyright 2005-6 American Bishoujo'

        ui.vbox(ypos=0.5, xpos=0.5, xanchor='center', yanchor='center')

        ui.text(text, xpos=0.5, xanchor='center', ypos=0.5, yanchor='center',
                textalign=0.5)

        ui.textbutton(u'Návrat do hlavního menu.', clicked=ui.returns(True))


        ui.text("")

        ui.text(u"\nCopyright 2005-6 PyTom/American Bishoujo.\nNěkteré práva vyhrazeny.",
                xpos=0.5, xanchor='center', ypos=0.5, yanchor='center',
                textalign=0.5)


        ui.close()
        ui.interact()

        renpy.full_restart()

# Code for the MW image gallery.
init:
    python:
        def gallery_button(x, y, page, condition):
            if eval(condition):
                ui.button(xpos=x, ypos=y, xanchor=0, yanchor=0, clicked=ui.jumps("gallery_" + page))
                ui.image("gal-" + page + ".png")
            else:
                ui.image("gal-locked.png", xpos=x, ypos=y, xanchor=0, yanchor=0)

label gallery:

    scene beach3

    python:
        # x 50, 300, 550
        # y 37, 224, 411

        gallery_button(50, 37, "dark", "persistent.unlock_dark")
        gallery_button(300, 37, "dawn", "persistent.unlock_dawn")
        gallery_button(550, 37, "end1", "persistent.unlock_1")

        gallery_button(50, 224, "end2", "persistent.unlock_2")
        gallery_button(300, 224, "end3", "persistent.unlock_3")
        gallery_button(550, 224, "end4", "persistent.unlock_4")

        gallery_button(50, 411, "dark_mary", "persistent.unlock_1 and persistent.unlock_2 and persistent.unlock_3 and persistent.unlock_4")
        gallery_button(300, 411, "dawn_mary", "persistent.unlock_1 and persistent.unlock_2 and persistent.unlock_3 and persistent.unlock_4")

        ui.textbutton(u"Zpět", xanchor=.5, yanchor=.5,
                      xpos=550 + 200 / 2, ypos=411 + 150 / 2,
                      xpadding=20, ypadding=15,
                      background=Frame('saveslot.png', 16, 16),
                      clicked=ui.returns(True),
                      )

        renpy.transition(dissolve)
        ui.interact()

    # This is an undocumented hack. I need to figure out a better way
    # to do this.
    $ dont_set_music = True
    scene black
    $ renpy.call_in_new_context("_enter_main_menu")
    jump start


label gallery_dark:

    scene beach1 with dissolve
    $ renpy.pause(10)

    scene beach1 mary with dissolve
    $ renpy.pause(10)

    scene beach2 with dissolve
    $ renpy.pause(10)

    scene beach3 with dissolve
    $ renpy.pause(10)

    jump gallery

label gallery_dawn:

    scene dawn1 with dissolve
    $ renpy.pause(10)

    scene dawn2 with dissolve
    $ renpy.pause(10)

    jump gallery

label gallery_end1:

    scene transfer with dissolve
    $ renpy.pause(10)

    scene moonpic with dissolve
    $ renpy.pause(10)

    scene nogirlpic with dissolve
    $ renpy.pause(10)

    scene bad_ending with dissolve
    $ renpy.pause(10)

    jump gallery

label gallery_end2:

    scene library with dissolve
    $ renpy.pause(10)

    scene beach1 nomoon with dissolve
    $ renpy.pause(10)

    scene bad_ending with dissolve
    $ renpy.pause(10)

    jump gallery

label gallery_end3:

    scene littlemary with dissolve
    $ renpy.pause(10)

    scene good_ending with dissolve
    $ renpy.pause(10)

    jump gallery

label gallery_end4:

    scene hospital1 with dissolve
    $ renpy.pause(10)

    scene hospital3 with dissolve
    $ renpy.pause(10)

    scene heaven with dissolve
    $ renpy.pause(10)

    scene white with slowdissolve
    $ renpy.pause(1)

    scene good_ending with slowdissolve
    $ renpy.pause(10)

    jump gallery

label gallery_dawn_mary:

    scene dawn1
    show mary dawn confused smiling
    with dissolve
    $ renpy.pause(5)

    show mary dawn confused wistful with dissolve
    $ renpy.pause(5)

    show mary dawn wistful with dissolve
    $ renpy.pause(5)

    show mary dawn smiling with dissolve
    $ renpy.pause(5)

    show mary dawn vhappy with dissolve
    $ renpy.pause(5)

    jump gallery

label gallery_dark_mary:

    scene beach2
    show mary dark confused smiling
    with dissolve
    $ renpy.pause(5)

    show mary dark confused wistful with dissolve
    $ renpy.pause(5)

    show mary dark sad with dissolve
    $ renpy.pause(5)

    show mary dark crying with dissolve
    $ renpy.pause(5)

    show mary dark wistful with dissolve
    $ renpy.pause(5)

    show mary dark smiling with dissolve
    $ renpy.pause(5)

    show mary dark laughing with dissolve
    $ renpy.pause(5)

    show mary dark vhappy with dissolve
    $ renpy.pause(5)

    jump gallery
